<?php
/**
 * ============================================
 * SHADOW PRO - Configuration File
 * ============================================
 * 
 * IMPORTANT: Change all credentials before deployment!
 * Store this file securely - DO NOT SHARE
 */

// Security: Prevent direct access
defined('SHADOW_PRO') or die('Direct access denied');

// ============================================
// DATABASE CONFIGURATION
// ============================================
define('DB_HOST', 'localhost');
define('DB_NAME', 'shadowhu_pro');
define('DB_USER', 'shadowhu_pro');
define('DB_PASS', 'Youssef_JoO_Y1%&');
define('DB_CHARSET', 'utf8mb4');
define('DB_PREFIX', 'shadowhu_');

// ============================================
// SYSTEM CONFIGURATION
// ============================================
define('SYSTEM_VERSION', '2.0.0');
define('SYSTEM_NAME', 'Shadow PRO');
define('SALT_KEY', 'c5f8a3b7e2d9f1a4c6b8e3d7f2a9b5c1'); // 32-char random string
define('HASH_SALT', 'x9y8z7a6b5c4d3e2f1g0h9i8j7k6l5m4n3'); // 32-char random string
define('ENCRYPTION_KEY', '32characterencryptionkeyhere123456'); // 32 chars exactly

// ============================================
// SECURITY SETTINGS
// ============================================
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_TIMEOUT', 900); // 15 minutes
define('SESSION_TIMEOUT', 3600); // 1 hour
define('IP_BAN_THRESHOLD', 50); // Auto-ban threshold

// ============================================
// PATHS & DIRECTORIES
// ============================================
define('BASE_PATH', dirname(__FILE__));
define('LOG_PATH', BASE_PATH . '/logs');
define('ASSETS_PATH', BASE_PATH . '/assets');

// ============================================
// BOT DETECTION PATTERNS
// ============================================
$GLOBALS['BOT_PATTERNS'] = [
    'googlebot', 'bingbot', 'yandexbot', 'baiduspider', 'duckduckbot',
    'slurp', 'facebookexternalhit', 'twitterbot', 'linkedinbot',
    'telegrambot', 'discordbot', 'whatsapp', 'curl', 'wget',
    'python-requests', 'java', 'php', 'Go-http-client', 'node-fetch',
    'axios', 'okhttp', 'libwww-perl', 'apache-httpclient', 'scrapy',
    'pinterest', 'quora', 'vkShare', 'embedly', 'slackbot', 'feedfetcher',
    'spbot', 'msnbot', 'applebot', 'discordbot', 'redditbot', 'tumblr'
];

// ============================================
// COUNTRY CODES (ISO 3166-1 alpha-2)
// ============================================
$GLOBALS['COUNTRY_CODES'] = [
    'US' => 'United States', 'GB' => 'United Kingdom', 'CA' => 'Canada',
    'AU' => 'Australia', 'DE' => 'Germany', 'FR' => 'France',
    'JP' => 'Japan', 'IN' => 'India', 'BR' => 'Brazil',
    'RU' => 'Russia', 'CN' => 'China', 'MX' => 'Mexico',
    'IT' => 'Italy', 'ES' => 'Spain', 'KR' => 'South Korea'
];

// ============================================
// ERROR HANDLING
// ============================================
error_reporting(0);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', LOG_PATH . '/errors.log');

// ============================================
// TIMEZONE
// ============================================
date_default_timezone_set('UTC');

// ============================================
// SESSION SECURITY
// ============================================
session_name('shadow_pro_sess');
session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'domain' => '',
    'secure' => isset($_SERVER['HTTPS']),
    'httponly' => true,
    'samesite' => 'Strict'
]);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ============================================
// SECURITY HEADERS
// ============================================
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');

// ============================================
// HELPER FUNCTIONS
// ============================================

/**
 * Encrypt data using AES-256-CBC
 */
function shadow_encrypt($data, $key = ENCRYPTION_KEY) {
    $iv = openssl_random_pseudo_bytes(16);
    $ciphertext = openssl_encrypt(
        $data,
        'AES-256-CBC',
        hash('sha256', $key, true),
        OPENSSL_RAW_DATA,
        $iv
    );
    return base64_encode($iv . $ciphertext);
}

/**
 * Decrypt data using AES-256-CBC
 */
function shadow_decrypt($data, $key = ENCRYPTION_KEY) {
    $data = base64_decode($data);
    $iv = substr($data, 0, 16);
    $ciphertext = substr($data, 16);
    return openssl_decrypt(
        $ciphertext,
        'AES-256-CBC',
        hash('sha256', $key, true),
        OPENSSL_RAW_DATA,
        $iv
    );
}

/**
 * Generate secure hash with salt
 */
function shadow_hash($data) {
    return hash_hmac('sha256', $data, SALT_KEY);
}

/**
 * Hash IP for privacy
 */
function shadow_hash_ip($ip) {
    return hash_hmac('sha256', $ip . HASH_SALT, SALT_KEY);
}

/**
 * Sanitize input data
 */
function shadow_sanitize($input) {
    if (is_array($input)) {
        return array_map('shadow_sanitize', $input);
    }
    return htmlspecialchars(trim($input), ENT_QUOTES | ENT_HTML5, 'UTF-8');
}

/**
 * Detect country from IP (simplified)
 */
function detect_country_from_ip($ip) {
    // Note: For production, use GeoIP database or API
    // This is a simplified version
    return 'US'; // Default to USA
}

/**
 * Detect device type from User-Agent
 */
function detect_device_type($ua) {
    $ua = strtolower($ua);
    if (strpos($ua, 'mobile') !== false) return 'mobile';
    if (strpos($ua, 'tablet') !== false || strpos($ua, 'ipad') !== false) return 'tablet';
    if (preg_match('/bot|crawler|spider/i', $ua)) return 'bot';
    return 'desktop';
}

/**
 * Detect browser from User-Agent
 */
function detect_browser($ua) {
    $ua = strtolower($ua);
    if (strpos($ua, 'chrome') !== false) return 'Chrome';
    if (strpos($ua, 'firefox') !== false) return 'Firefox';
    if (strpos($ua, 'safari') !== false && strpos($ua, 'chrome') === false) return 'Safari';
    if (strpos($ua, 'edge') !== false) return 'Edge';
    if (strpos($ua, 'opera') !== false) return 'Opera';
    return 'Unknown';
}
?>