-- ============================================
-- SHADOW PRO Database Schema
-- ============================================

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

-- --------------------------------------------------------
-- Table: shadow_admins (Admin Users)
CREATE TABLE `shadow_admins` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `login_ip` varchar(45) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_active` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Default admin: admin / ShadowPro@2024
INSERT INTO `shadow_admins` (`id`, `username`, `password_hash`) VALUES
(1, 'admin', '$2y$10$Xw7n3CvKQr5Z8YbN9Mp6LeA1B2C3D4E5F6G7H8I9J0K1L2M3N4O5P6Q7R8S9T0');

-- --------------------------------------------------------
-- Table: shadow_links (Redirect Destinations)
CREATE TABLE `shadow_links` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `url` varchar(1000) NOT NULL,
  `title` varchar(100) NOT NULL,
  `priority` int(11) DEFAULT 1 COMMENT '1=highest',
  `weight` int(11) DEFAULT 100 COMMENT 'For weighted distribution',
  `status` enum('active','backup','emergency','disabled') DEFAULT 'active',
  `health_status` enum('online','slow','offline','unknown') DEFAULT 'unknown',
  `last_checked` datetime DEFAULT NULL,
  `total_redirects` int(11) DEFAULT 0,
  `successful_redirects` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `status_priority` (`status`,`priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Sample redirect links
INSERT INTO `shadow_links` (`id`, `url`, `title`, `priority`, `weight`, `status`) VALUES
(1, 'https://primary.example.com', 'Primary Destination', 1, 100, 'active'),
(2, 'https://backup.example.com', 'Backup Destination', 2, 50, 'backup'),
(3, 'https://emergency.example.com', 'Emergency Fallback', 3, 10, 'emergency');

-- --------------------------------------------------------
-- Table: shadow_visits (Visitor Tracking)
CREATE TABLE `shadow_visits` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `visitor_hash` varchar(64) NOT NULL,
  `ip_hash` varchar(64) NOT NULL,
  `fingerprint` varchar(128) NOT NULL COMMENT 'Advanced fingerprint hash',
  `user_agent` text DEFAULT NULL,
  `http_headers` json DEFAULT NULL,
  `country_code` char(2) DEFAULT NULL,
  `device_type` enum('desktop','mobile','tablet','bot','unknown') DEFAULT 'unknown',
  `browser` varchar(50) DEFAULT NULL,
  `classification` enum('human','bot','suspicious','blocked') DEFAULT 'human',
  `redirect_link_id` int(11) DEFAULT NULL,
  `redirect_mode` enum('primary','failover','emergency','none') DEFAULT NULL,
  `processing_time` float DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `visitor_hash` (`visitor_hash`),
  KEY `fingerprint` (`fingerprint`),
  KEY `classification` (`classification`),
  KEY `created_at` (`created_at`),
  KEY `redirect_link_id` (`redirect_link_id`),
  KEY `country_code` (`country_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- Table: shadow_whitelist (Testing IP Whitelist)
CREATE TABLE `shadow_whitelist` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(45) NOT NULL,
  `note` varchar(200) DEFAULT NULL,
  `added_by` varchar(50) DEFAULT NULL,
  `added_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip_address` (`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- Table: shadow_settings (System Configuration)
CREATE TABLE `shadow_settings` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(50) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Default system settings
INSERT INTO `shadow_settings` (`setting_key`, `setting_value`) VALUES
('system_enabled', '1'),
('redirect_mode', 'failover'),
('redirect_delay', '0'),
('bot_protection', '1'),
('country_filter', '1'),
('allowed_countries', 'US'),
('default_country', 'US'),
('failover_enabled', '1'),
('privacy_mode', '0'),
('admin_ip_restrict', '0'),
('admin_allowed_ips', ''),
('dashboard_theme', 'neon'),
('last_stats_update', CURRENT_TIMESTAMP);

COMMIT;